
-- eActiv, eLongActiv must be booleans (not 0/1)
-- E_activated -> if not make an empty matrix
local function make(latitudes, initTotVa, Ke, eLongActiv, eLongStD)
    local nLines = #latitudes
    local nCols = #latitudes[1]
    local Es = make_matrix(0, nLines, nCols)

       
    -- E long (random columns effect)
    -- TODO: WHY must the first value always be 0?
    local eLong = rep(0, nCols) -- nCols = n long lvls
    if eLongActiv and nCols > 1 then
        for long = 2, nCols, 1  do
            eLong[long] = gasdev() * eLongStD
        end
    end  
    
    -- E
    local varLat = stats.variance_matrix(latitudes)
    local const = math.sqrt( Ke * initTotVa / varLat)

    for lat = 1, #latitudes do
        for long = 1, #latitudes[lat] do
            Es[lat][long] = const * latitudes[lat][long] + eLong[long]
        end
    end
    
    return Es
end


-------------------------------     Packing        -----------------------------

local E = {}
E.make = make
return E
