--------------------------------------------------------------------------------
------------------------------ Matching data function --------------------------
--------------------------------------------------------------------------------

-- Matching Traits & usrData (Zopt, E, Sel_int, Allelic effects), by trait id
local function trait_data(usrTraits, userDataFrames)
    --for _, trait in ipairs(usrTraits) do
    --    print(trait["e"])
    --end

    for _, trait in ipairs(usrTraits) do
        local id = trait.id
        print(id) -- delete
        -- Zopts
        if userDataFrames["zopt"] ~= nil and userDataFrames["zopt"][id] ~= nil then
            trait["zopt"] = userDataFrames["zopt"][id]
            print(" - Matching Zopt for trait "..id)
        end
        -- Environmental effects
        if userDataFrames["e"] ~= nil and userDataFrames["e"][id] ~= nil then
            trait["e"] = userDataFrames["e"][id]
            print(" - Matching environemental effect for trait "..id)
            --print(#trait["e"])
        end
        -- Selection Intensity
        if  userDataFrames["selection_intensity"] ~= nil
        and userDataFrames["selection_intensity"][id] ~= nil then
            trait["selInt"] = userDataFrames["selection_intensity"][id] -- CARE: CHANGE NAME selection_intensity -> selInt
            print(" - Matching Selection Intensity for trait "..id)
        end
        -- Allelic effects
        if  userDataFrames["allelic_effects"] ~= nil
        and userDataFrames["allelic_effects"][id] ~= nil then
            trait["allelicEffects"] = userDataFrames["allelic_effects"][id]
            print(" - Matching Allelic effect for trait "..id)
        end
    end
    --for _, trait in ipairs(usrTraits) do
    --    print(type(trait["e"]))
    --end
    --print("ustr_traits match.lua?"..type(usrTraits))

    return usrTraits
end


-- Matching species and user data (flux matrix, flux pattern) by id
local function species_data(usrSpecies, userDataFrames)
    for _, species in ipairs(usrSpecies) do
        local speId = species.id
        -- flux matrix
        if  userDataFrames["flux_matrix"] ~= nil 
        and userDataFrames["flux_matrix"][speId] ~= nil then
            species["fluxMatrix"] = userDataFrames["flux_matrix"][speId]
            print(" - Matching Flux Matrix for species "..speId)
        end
        -- flux pattern
        if  userDataFrames["flux_pattern"] ~= nil 
        and userDataFrames["flux_pattern"][speId] ~= nil then
            species["fluxPattern"] = userDataFrames["flux_pattern"][speId]
            print(" - Matching Flux Pattern for species "..speId)
        end
    end
    return usrSpecies
end




-- Matching Species & traits by id
local function species_traits(usrSpecies, usrTraits)
    -- For each trait & species pairs
    for _, trait in ipairs(usrTraits) do
        for _, species in ipairs(usrSpecies) do
            if species.traits == nil then  species.traits = {} end
            if trait.species == species.id then 
                species.traits[trait.id] = trait 
            end
        end
    end
    return usrSpecies
end


-- Loading individuals according their to species
-- Only filters existing species...
local function individuals(userDataFrames, usrSpecies)
    local individuals = {}
    for _, species in ipairs(usrSpecies) do
        local speId = species.id
        if  userDataFrames["individuals"] ~= nil 
        and userDataFrames["individuals"][speId] ~= nil then
            --print("TABLE IND SPE EXISTS")
            individuals[speId] = userDataFrames["individuals"][speId]
        end
    end
    return individuals
end

-- Loading demographics according their to species
-- Only filters existing species...
local function demo(userDataFrames, usrSpecies)
    local demo = {}
    for _, species in ipairs(usrSpecies) do
        local speId = species.id
        if  userDataFrames["demography"] ~= nil then
            if userDataFrames["demography"][speId] ~= nil then
                demo[speId] = userDataFrames["demography"][speId] -- CAUTION demography -> demo
            end
        end
    end
    return demo
end


--------------------------------------------------------------------------------
-------------------------------  Module interface ------------------------------
--------------------------------------------------------------------------------
local module = {}
module.trait_data = trait_data
module.species_data = species_data
module.species_traits = species_traits
module.individuals = individuals
module.demo = demo
return module
