id = "T1"
species = "S1"

-- Heritability of the trait
h2 = 0.833

--Locus weight for allelic effects
varLociWeights = 0  -- Changed to have uniform locus weight (all at 1), before was at 2 (gamma distrib)

-- Selection Intensity
selIntParam =
{
    -- Allowed values: userdata, value
    -- If source == "userdata": matrix sel_int.txt directly filled by user
    -- If source == "value": a unique value is assigned to all cells
    source = "value",
    omega = 1000000000, -- neutral selection
}

-- Macro-environmental effect E
envEffParam =
{
    -- Source of data, allowed values: userdata, value, param
    -- If source == "userdata": matrix e.txt directly filled by user
    -- If source == "value": a unique value is assigned to all cells, arg: E = number
    -- If source == "param": generation of a gradient according to one dimension, arg: Ke = number
    source = "value",
    E = 2 ,
}

-- Optimal trait value Zopt
zoptParam =
{
    -- Source of data, allowed values: userdata, value, param
    -- If source == "userdata": matrix zopt.txt directly filled by user
    -- If source == "value": a unique value is assigned to all cells, arg: zopt = number
    -- If source == "param": generation of a gradient according to one dimension, args: opposed = boolean, Kzopt = number
    source = "param",
    opposed = false,
    Kzopt = 1.7,
}

-- Phenotypic plasticity
-- If non heritable phenotypic plasticity, Z = G + E + epsilon (only loci of type a)
-- no GxE interaction, nhpp should be true
nhpp = false
-- Otherwise Z = a + bE + epsilon, two kinds of locus: a (intercept of reaction norm) and b (slope)
-- reference environmental value Eref required
Eref = 0.5

ltypes = {
{
    id = "a",
    lociList = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20},
    phi = 0.45,
},
{
    id = "b",
    lociList = {},
    phi = 0.45,
}
}
