#!/usr/bin/env Rscript
#Get loci weights in a gamma distribution


#Typical launch command example
#./gamma_standard.r gammaParam=2 nloc=42 Seed=1349 > test

###### Function for a better parsing of arguments, Can be safely ignored #######
###### From: http://cwcode.wordpress.com/2013/04/16/the-joys-of-rscript/ #######
getArgs <- function(verbose=FALSE, defaults=NULL) {
    myargs <- gsub("^--", "", commandArgs(TRUE))
    setopts <- !grepl("=", myargs)
    if(any(setopts))
        myargs[setopts] <- paste(myargs[setopts], "=notset", sep="")
    myargs.list <- strsplit(myargs, "=")
    myargs <- lapply(myargs.list, "[[", 2 )
    names(myargs) <- lapply(myargs.list, "[[" , 1)

    ## logicals
    if(any(setopts))
        myargs[setopts] <- TRUE

    ## defaults
    if(!is.null(defaults))
    {
        defs.needed <- setdiff(names(defaults), names(myargs))
        if(length(defs.needed))
        {
            myargs[ defs.needed ] <- defaults[ defs.needed ]
        }
    }

    ## verbage
    if(verbose) {
    cat("read",length(myargs),"named args:\n")
    print(myargs)
    }
    myargs
}
################################################################################





#Get args using the function above
myargs = getArgs()
nloc = as.numeric(myargs$nloc)
gammaParam = as.numeric(myargs$gammaParam)
#Lua compatible syntax
cat("loci_weight = { ")
for(i in 1:nloc){  #For each locus
    newGammaVal = rgamma(1, gammaParam)
    cat(newGammaVal,", ")
}

cat("}")
cat("\nreturn ", "loci_weight", sep = "")